---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：20-Segment Replication Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行49-53（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行67-85（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行68-75（リクエストパラメータ設定）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行88-126（テーブルヘッダー定義）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行96-104（通常モード8カラム）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行105-123（detailedモード追加17カラム）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行136-202（buildSegmentReplicationTable処理）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行151-155（CollectionUtil.introSort シャードID昇順）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行162-165（state==null時continue）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行146-148（isEmpty時continue）
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行167-196（テーブル行構築）
- E-12: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行173（ByteSizeValue変換）
- E-13: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行174-175（TimeValue変換）
- E-14: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行178（stage小文字変換）
- E-15: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行181-183（パーセント形式%1.1f%%）
- E-16: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行184-185（DEFAULT_FORMATTER使用）
- E-17: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` 行190-194（5ステージ時間出力）
- E-18: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行21（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/segment_replication と /_cat/segment_replication/{index} | E-01 | ○ |
| C-02 | SegmentReplicationStatsRequestを使用 | E-02 | ○ |
| C-03 | index, detailed, active_only, shards パラメータ対応 | E-03 | ○ |
| C-04 | 通常モードは8カラム | E-05 | ○ |
| C-05 | detailedモードで追加17カラム（合計25カラム） | E-06 | ○ |
| C-06 | shardId aliasは s | E-04 | ○ |
| C-07 | target_node aliasは tnode | E-04 | ○ |
| C-08 | checkpoints_behind aliasは cpb | E-04 | ○ |
| C-09 | bytes_behind はByteSizeValue形式 | E-12 | ○ |
| C-10 | current_lag はTimeValue形式 | E-13 | ○ |
| C-11 | シャードIDで昇順ソート（CollectionUtil.introSort） | E-08 | ○ |
| C-12 | state==null時はcontinue | E-09 | ○ |
| C-13 | isEmpty時はcontinue | E-10 | ○ |
| C-14 | stage は小文字で出力（toLowerCase） | E-14 | ○ |
| C-15 | files_percentは%1.1f%%形式 | E-15 | ○ |
| C-16 | bytes_percentは%1.1f%%形式 | E-15 | ○ |
| C-17 | start_time/stop_timeはDEFAULT_FORMATTER使用 | E-16 | ○ |
| C-18 | 5つのステージ時間カラム（replicating, get_checkpoint_info, file_diff, get_files, finalize_replication） | E-17 | ○ |
| C-19 | 3重ループ（インデックス→グループ→レプリカ） | E-07 | ○ |
| C-20 | OpenSearch固有の機能 | E-18 | ○ |
| C-21 | IndicesOptions.fromRequest対応 | E-03 | ○ |
| C-22 | アクション名は cat_segment_replication_action | E-01 | ○ |
| C-23 | ソースファイルは全203行 | E-07 | ○ |
| C-24 | 帳票名は「Segment Replication Report」 | E-18 | ○ |
| C-25 | rejected_requests はPerGroupStats単位 | E-11 | ○ |
| C-26 | indices:monitor/segment_replication 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・ソート・3重ループ・各ステージ時間（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] 通常8カラム/detailed25カラムの定義が正確か確認
- [ ] 5つのステージ時間カラムが正確か確認
- [ ] CollectionUtil.introSortの動作仕様が記述と一致するか確認
- [ ] state==null時のスキップ処理確認
- [ ] セキュリティ権限名の確認
